﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Linq" %>

<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Waluty" %>



<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Wycena rozrachunków walutowych</title>
	<script runat="server">

		//
		// PARAMETERS
		//

		public enum Zakres
		{ Razem, Kontrahenci, Pracownicy, Urzędy }

		public enum TypDokumentow
		{ Zobowiązania, Należności, PerSaldo }

		public enum TypRozliczen
		{ Kasowe, Księgowe }


		public class PrnParams : OkresContext
		{
			private FromTo _okresKS;
			private Zakres _zakres = Zakres.Kontrahenci;
			private TypRozliczen _typRozliczen = TypRozliczen.Kasowe;
			private IPodmiotKasowy _odk;
			private IPodmiotKasowy _dok;
			private TypDokumentow _dokumenty = TypDokumentow.Należności;
			private RodzajDokumentów _rodzaj = RodzajDokumentów.Razem;
			private WalutaItem _waluta;
			private String _aktualneKonto = String.Empty;
			private TabelaKursowa _tabelaKursowa;
			private Date _dataKursu;


			public PrnParams(Context context)
				: base(context)
			{
				_waluta = WxRazem;
				_tabelaKursowa = WalutyModule.GetInstance(this).TabeleKursowe.NBP;
				_dataKursu = Date.Today;
				Okres = FromTo.All;
				_okresKS = FromTo.All;
			}


			[Priority(10)]
			[DefaultWidth(15)]
			public override Date Aktualny
			{
				get { return base.Aktualny; }
				set { base.Aktualny = value; }
			}


			[Priority(20)]
			[Caption("Data kursu")]
			[DefaultWidth(15)]
			[Required]
			public Date DataKursu
			{
				get { return _dataKursu; }
				set
				{
					_dataKursu = value;
					OnChanged();
				}
			}


			[Priority(30)]
			[Caption("Tabela kursowa")]
			[DefaultWidth(25)]
			[Required]
			public TabelaKursowa TabelaKursowa
			{
				get { return _tabelaKursowa; }
				set
				{
					_tabelaKursowa = value;
					OnChanged();
				}
			}


			[Priority(40)]
			[DefaultWidth(15)]
			public WalutaItem Waluta
			{
				get { return _waluta; }
				set
				{
					_waluta = value ?? WxRazem;
					OnChanged();
				}
			}


			[Priority(50)]
			[DefaultWidth(15)]
			[Caption("Typ rozliczeń")]
			public TypRozliczen TypRozliczen
			{
				get { return _typRozliczen; }
				set
				{
					_typRozliczen = value;
					OnChanged();
				}
			}


			[Priority(60)]
			[DefaultWidth(15)]
			public new FromTo Okres
			{
				get { return base.Okres; }
				set
				{
					base.Okres = value != FromTo.Empty ? value : FromTo.All;
					OnChanged();
				}
			}


			[Priority(70)]
			[DefaultWidth(15)]
			[Caption("Okres księgowy")]
			public FromTo OkresKS
			{
				get { return _okresKS; }
				set
				{
					_okresKS = value != FromTo.Empty ? value : FromTo.All;
					OnChanged();
				}
			}


			[Priority(80)]
			[DefaultWidth(15)]
			public Zakres Zakres
			{
				get { return _zakres; }
				set { _zakres = value; OnChanged(); }
			}


			[Priority(90)]
			[DefaultWidth(25)]
			[Caption("Od kontrahenta")]
			public IPodmiotKasowy Od
			{
				get { return _odk; }
				set
				{
					_odk = value;
					OnChanged();
				}
			}


			[Priority(100)]
			[DefaultWidth(25)]
			[Caption("Do kontrahenta")]
			public IPodmiotKasowy Do
			{
				get { return _dok; }
				set
				{
					_dok = value;
					OnChanged();
				}
			}


			[Priority(110)]
			[DefaultWidth(15)]
			public TypDokumentow Dokumenty
			{
				get { return _dokumenty; }
				set
				{
					_dokumenty = value;
					OnChanged();
				}
			}


			[Priority(120)]
			[DefaultWidth(15)]
			[Caption("Rodzaj")]
			public RodzajDokumentów Rodzaj
			{
				get { return _rodzaj; }
				set
				{
					_rodzaj = value;
					OnChanged();
				}
			}


			[Priority(130)]
			[DefaultWidth(25)]
			public String AktualneKonto
			{
				get { return _aktualneKonto; }
				set
				{
					_aktualneKonto = value.ToUpper();
					OnChanged();
				}
			}


			private WalutaItem[] waluty;


			public WalutaItem[] GetListWaluta()
			{
				if (waluty == null)
				{
					var lst = new List<WalutaItem>
					{
						WxRazem, WxNoPln
					};
					
					lst.AddRange(from Waluta waluta in WalutyModule.GetInstance(this).Waluty.WgSymbolu select new WalutaItem(waluta));
					waluty = lst.ToArray();
				}

				return waluty;
			}


			private readonly Dictionary<String, Waluta> cacheWaluty = new Dictionary<String, Waluta>();


			internal Waluta GetWaluta(String symbol)
			{
				if (cacheWaluty.ContainsKey(symbol))
					return cacheWaluty[symbol];

				var wal = WalutyModule.GetInstance(this).Waluty.WgSymbolu[symbol];
				if (wal == null)
					throw new ApplicationException(String.Format("Nie znaleziono waluty o symbolu '{0}'.", symbol));

				cacheWaluty[symbol] = wal;
				return wal;
			}
		}


		[Context(Required = true)]
		public PrnParams Params
		{
			get { return pars; }
			set { pars = value; }
		}

		
		[Context(Required = true)]
		public WydrukOddzialParams OParams { get; set; }



		//
		// Custom Lookup Item do waluty
		//


		public static readonly WalutaItem WxRazem = new WalutaItem(true);
		public static readonly WalutaItem WxNoPln = new WalutaItem(false);


		public class WalutaItem : CustomLookupItem
		{
			public enum Typ
			{ Razem, NoPln, Specific, }


			private readonly Waluta _waluta;
			private readonly Typ _recordType;


			public WalutaItem(Waluta waluta)
			{
				_recordType = Typ.Specific;
				_waluta = waluta;
			}


			public WalutaItem(Boolean allRecords)
			{
				_recordType = allRecords ? Typ.Razem : Typ.NoPln;
				_waluta = null;
			}


			public override String Kod
			{
				get
				{
					switch (_recordType)
					{
						case Typ.Razem: return "Razem";
						case Typ.NoPln: return "Bez PLN";
						default: return _waluta.Symbol;
					}
				}
			}


			public override String Nazwa
			{ get { return Kod; } }

			public Waluta Origin
			{ get { return _waluta; } }

			public Typ RecordType
			{ get { return _recordType; } }

			public override String ToString()
			{ return Kod; }
		}


		//
		// LOCAL VARIABLES
		//


		private PrnParams pars;
		private readonly WydrukiRozrachunkowFiltr wr = new WydrukiRozrachunkowFiltr();


		private class IdxProxy : IComparable<IdxProxy>
		{
			private readonly RozrachunekIdx _idx;
			private readonly Currency _kwotaDokumentu;
			private readonly Currency _kwotaWyceny;
			private readonly Currency _histKwota;
			private readonly Double _kursWyceny;
			private readonly Double _kursHist;
			private readonly Currency _roznicaZysk;


			public RozrachunekIdx Idx
			{ get { return _idx; } }

			public Date DataDokumentu
			{ get { return _idx.Data; } }

			public String NumerDokumentu
			{ get { return _idx.Numer; } }

			public Currency KwotaDokumentu
			{ get { return _kwotaDokumentu; } }

			public Currency HistKwota
			{ get { return _histKwota; } }

			public Double HistKurs
			{ get { return _kursHist; } }

			public Currency WycenaKwota
			{ get { return _kwotaWyceny; } }

			public Double WycenaKurs
			{ get { return _kursWyceny; } }

			public Currency RoznicaZysk
			{ get { return _roznicaZysk > Currency.Zero ? _roznicaZysk : Currency.Zero; } }

			public Currency RoznicaStrata
			{ get { return _roznicaZysk < Currency.Zero ? -_roznicaZysk : Currency.Zero; } }



			internal IdxProxy(RozrachunekIdx idx, StanRozliczeniaRozrachunkuWorker worker, PrnParams prms)
			{
				_idx = idx;
				Currency kwotaZeZnakiem;

				if (prms.TypRozliczen == TypRozliczen.Kasowe)
				{
					switch (prms.Dokumenty)
					{
						case TypDokumentow.Należności:
							_kwotaDokumentu = worker.Naleznosc(prms.Aktualny);
							_histKwota = worker.NaleznoscPLNHist(prms.Aktualny);
							break;

						case TypDokumentow.Zobowiązania:
							_kwotaDokumentu = worker.Zobowiazanie(prms.Aktualny);
							_histKwota = worker.ZobowiazaniePLNHist(prms.Aktualny);
							break;

						default:
							_kwotaDokumentu = worker.Naleznosc(prms.Aktualny) - worker.Zobowiazanie(prms.Aktualny);
							_histKwota = worker.NaleznoscPLNHist(prms.Aktualny) - worker.ZobowiazaniePLNHist(prms.Aktualny);
							break;
					}

				    _kursHist = ((IRozliczalnyCy) idx.Dokument).Kurs;
				    kwotaZeZnakiem = worker.Naleznosc(prms.Aktualny) - worker.Zobowiazanie(prms.Aktualny);
				}
				else
				{
					switch (prms.Dokumenty)
					{
						case TypDokumentow.Należności:
							_kwotaDokumentu = worker.NaleznoscKsiOpe(prms.Aktualny);
							_histKwota = worker.NaleznoscKsi(prms.Aktualny);
							break;

						case TypDokumentow.Zobowiązania:
							_kwotaDokumentu = worker.ZobowiazanieKsiOpe(prms.Aktualny);
							_histKwota = worker.ZobowiazanieKsi(prms.Aktualny);
							break;

						default:
							_kwotaDokumentu = worker.NaleznoscKsiOpe(prms.Aktualny) - worker.ZobowiazanieKsiOpe(prms.Aktualny);
							_histKwota = worker.NaleznoscKsi(prms.Aktualny) - worker.ZobowiazanieKsi(prms.Aktualny);
							break;
					}

				    _kursHist = ((IRozliczalnyCy) idx.Dokument).Kurs;
					kwotaZeZnakiem = worker.NaleznoscKsiOpe(prms.Aktualny) - worker.ZobowiazanieKsiOpe(prms.Aktualny);
				}

				if (_kwotaDokumentu.Symbol == Currency.SystemSymbol)
				{
					_kursWyceny = 1d;
					_kwotaWyceny = _kwotaDokumentu;
				}
				else
				{
					var waluta = prms.GetWaluta(_kwotaDokumentu.Symbol);
					var kurs = prms.TabelaKursowa.KursWgDatyOgłoszenia(waluta, prms.DataKursu, true, false);

					_kursWyceny = kurs.Kurs;
					_kwotaWyceny = KasaForNegatives.GetCurrency(kurs.PrzeliczZ((double)_kwotaDokumentu.Value));
				}

				_roznicaZysk = kwotaZeZnakiem >= Currency.Zero ? Currency.Abs(_kwotaWyceny) - Currency.Abs(_histKwota) : Currency.Abs(_histKwota) - Currency.Abs(_kwotaWyceny);
			}


			public int CompareTo(IdxProxy idxProxy)
			{
				int comp;

				if ((comp = String.Compare(_idx.Podmiot.Kod, idxProxy._idx.Podmiot.Kod, StringComparison.CurrentCultureIgnoreCase)) != 0)
					return comp;
				if ((comp = String.Compare(_idx.Podmiot.Nazwa, idxProxy._idx.Podmiot.Nazwa, StringComparison.CurrentCultureIgnoreCase)) != 0)
					return comp;
				if ((comp = _idx.Data.CompareTo(idxProxy._idx.Data)) != 0)
					return comp;

				return _idx.ID.CompareTo(idxProxy._idx.ID);
			}
		}


		private void OnContextLoad(object sender, EventArgs e)
		{
			wr.PodmiotOd = pars.Od;
			wr.PodmiotDo = pars.Do;
			wr.Waluta = pars.Waluta.Origin;
			wr.SetAktualneKonto(pars.AktualneKonto, pars.Aktualny);

			//
			// NAGŁÓWEK RAPORTU
			//

			ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
			ReportHeader1["KURS"] = "</STRONG>Wg tabeli kursowej: <STRONG>" + pars.TabelaKursowa + "</STRONG> z dnia: <STRONG>" + pars.DataKursu;
			ReportHeader1["TYPROZLICZEN"] = pars.TypRozliczen == TypRozliczen.Kasowe ? "kasowych" : "księgowych";
			ReportHeader1["TYPRODZAJ"] = GetHeaderTypRodzaj();
			ReportHeader1["ZAKRES"] = pars.Zakres == Zakres.Razem ? String.Empty : "|</STRONG>Zakres: <STRONG>" + pars.Zakres;
			ReportHeader1["KONTRAHENT"] = wr.GetTitleStringPodmiot();
			ReportHeader1["KONTO"] = wr.GetTitleStringKonto();
			ReportHeader1["WALUTA"] = "|</STRONG>Waluta: <STRONG>" + pars.Waluta.Kod;

			//
			// QUERY
			//

			KasaModule kasa = KasaModule.GetInstance(dc);
			Soneta.Business.View view;

			if (pars.TypRozliczen == TypRozliczen.Kasowe)
			{
				//
				// -> rozliczenia kasowe:
				// - rachunki nierozliczone na dzień aktualności
				// - z odpowiednim okresem wystawienia
				// - z odpowiednim okresem księgowania
				//

				view = kasa.RozrachunkiIdx.Nierozliczone(null, pars.Okres, pars.Aktualny);

				if (pars.OkresKS != FromTo.All)
					view.Condition &= new FieldCondition.Contain("DataKsiegowania", pars.OkresKS);
			}
			else
			{
				//
				// -> rozliczenia księgowe:
				// - bez ograniczenia na rozliczenie kasowe
				// - odpowiednik wyszukiwania na widoku rozliczeń KS niezaksięgowanych
				//

				view = kasa.RozrachunkiIdx.CreateView();
				view.Condition = new FieldCondition.Contain("DataKsiegowania", pars.OkresKS * new FromTo(Date.MinValid + 1, Date.MaxValid - 1));

				if (pars.Okres != FromTo.All)
					view.Condition &= new FieldCondition.Contain("Data", pars.Okres);

				view.Condition &= new FieldCondition.Greater("DataOstatniegoKsi", pars.Aktualny) | new FieldCondition.Equal("DataRozliczenia", Date.MaxValue);
			}

			view.Condition &= ZakresCondition();
			view.Condition &= RodzajCondition(kasa.RozrachunkiIdx);
			view.Condition &= OParams.GetConditionIdx();

			var srrWorker = new StanRozliczeniaRozrachunkuWorker
			{
				StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone,
				StanRozliczeniaKs = StanRozliczeniaRozrachunku.Nierozliczone
			};

			wr.SetFilter(view);

			if (Params.Waluta.RecordType == WalutaItem.Typ.NoPln)
			{
				// bez PLN .. filtr automatyczny filtruje nam tylko wg symbolu waluty jesli została podana
				view.Condition &= new FieldCondition.NotEqual("Kwota.Symbol", Currency.SystemSymbol);
			}

			var lst = new List<IdxProxy>();

			foreach (var idx in view.Cast<RozrachunekIdx>())
			{
				srrWorker.RozrachunekIdx = idx;
				lst.Add(new IdxProxy(idx, srrWorker, pars));
			}

			lst.Sort();
			Grid1.DataSource = lst;
		}


		private String GetHeaderTypRodzaj()
		{
			var res = "|</STRONG>Typ dokumentów: <STRONG>";

			switch (pars.Dokumenty)
			{
				case TypDokumentow.Należności:
					res += "Należności";
					break;

				case TypDokumentow.Zobowiązania:
					res += "Zobowiązania";
					break;

				case TypDokumentow.PerSaldo:
					res += "Per Saldo";
					break;
			}

			if (pars.Rodzaj != RodzajDokumentów.Razem)
				res += ", </STRONG>Rodzaj: <STRONG>" + pars.Rodzaj;

			return res;
		}


		//
		// FILTRY
		//


		private RowCondition ZakresCondition()
		{
			switch (pars.Zakres)
			{
				case Zakres.Kontrahenci:
					return new FieldCondition.TypeOf("Podmiot", typeof(Kontrahent));

				case Zakres.Pracownicy:
					return new FieldCondition.TypeOf("Podmiot", typeof(Pracownik));

				case Zakres.Urzędy:
					RowCondition condition = new FieldCondition.TypeOf("Podmiot", typeof(Kontrahent));
					condition |= new FieldCondition.TypeOf("Podmiot", typeof(Pracownik));
					return new RowCondition.Not(condition);

				default:
					return RowCondition.Empty;
			}
		}


		private RowCondition RodzajCondition(RozrachunkiIdx idxTable)
		{
			var fNaleznosci = pars.Dokumenty != TypDokumentow.Zobowiązania;
			var fZobowiazania = pars.Dokumenty != TypDokumentow.Należności;
			var fZaplaty = pars.Rodzaj != RodzajDokumentów.Płatności;
			var fPlatnosci = pars.Rodzaj != RodzajDokumentów.Zapłaty;

			return idxTable.ZakresEx(fNaleznosci && fPlatnosci, fZobowiazania && fPlatnosci, fZobowiazania && fZaplaty, fNaleznosci && fZaplaty);
		}

	
    </script>
</head>

<body>
	<form id="WycenaNierozliczonychRozrachunkow" method="post" runat="server">
		<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true" />

		<cc1:ReportHeader ID="ReportHeader1" runat="server" ContextTypeName="Soneta.Business.OkresContext,Soneta.Business" DataMember0="Okres" DataMember1="Aktualny" DataMember2="OkresKS"
			Title="Wycena rozrachunków walutowych na dzień: {1}|%ODDZIAL%%KURS%|</STRONG> Wg rozliczeń: <STRONG>%TYPROZLICZEN%|</STRONG> Za okres: <STRONG>{0}, </STRONG> Za okres KS: <STRONG>{2}%TYPRODZAJ%%ZAKRES%%KONTRAHENT%%WALUTA%%KONTO%" />

		<p />
		<ea:Grid ID="Grid1" runat="server" GroupLine="{0}, {1}" GroupData0="Idx.Podmiot.Kod" GroupData1="Idx.Podmiot.Nazwa" EncodeHTML="true" ShowGroupSum="true" GroupSumText="Dla podmiotu:">
			<Columns>
				<ea:GridColumn Width="5" Align="Center" DataMember="#" Caption="Lp." runat="server" />
				<ea:GridColumn Width="12" Align="Center" DataMember="DataDokumentu" Caption="Data" runat="server" />
				<ea:GridColumn Width="0" Align="Left" DataMember="NumerDokumentu" Caption="Numer Dokumentu" runat="server" Total="Info" />
				<ea:GridColumn Width="18" Align="Right" DataMember="KwotaDokumentu" Caption="Kwota dokumentu" runat="server" Total="Sum" />
				<ea:GridColumn Width="18" Align="Right" DataMember="HistKwota" Caption="Dane historyczne~Kwota PLN" runat="server" Total="Sum" />
				<ea:GridColumn Width="11" Align="Right" DataMember="HistKurs" Caption="Dane historyczne~Kurs" Format="{0:f4}" HideZero="true" runat="server" />
				<ea:GridColumn Width="18" Align="Right" DataMember="WycenaKwota" Caption="Wartości wyceny~Kwota PLN" runat="server" Total="Sum" />
				<ea:GridColumn Width="11" Align="Right" DataMember="WycenaKurs" Caption="Wartości wyceny~Kurs" Format="{0:f4}" HideZero="true" runat="server" />
				<ea:GridColumn Width="18" Align="Right" DataMember="RoznicaStrata" Caption="Różnice kursowe~Strata" HideZero="true" runat="server" Total="Sum" />
				<ea:GridColumn Width="18" Align="Right" DataMember="RoznicaZysk" Caption="Różnice kursowe~Zysk" HideZero="true" runat="server" Total="Sum" />
			</Columns>
		</ea:Grid>
		<p />

		<cc1:ReportFooter ID="ReportFooter1" runat="server">
			<subtitles>
				<cc1:FooterSubtitle ID="FooterSubtitle1" runat="server" SubtitleType="Operator" />
				<cc1:FooterSubtitle ID="FooterSubtitle2" runat="server" Caption="Sporządził" SubtitleType="Podpis" />
				<cc1:FooterSubtitle ID="FooterSubtitle3" runat="server" Caption="Sprawdził" SubtitleType="Podpis" />
				<cc1:FooterSubtitle ID="FooterSubtitle4" runat="server" Caption="Zatwierdził" SubtitleType="Podpis" />
			</subtitles>
		</cc1:ReportFooter>
	</form>
</body>
</html>

